/**********
Copyright 2010 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/

/* CKTbindNode
 *  bind a node of the specified device of the given type to its place
 *  in the specified circuit.
 */

#include "spice.h"
#include <stdio.h>
#include "ifsim.h"
#include "smpdefs.h"
#include "cktdefs.h"
#include "util.h"
#include "devdefs.h"
#include "sperror.h"
#include "suffix.h"

extern SPICEdev *DEVices[];

/*ARGSUSED*/
int
CKTbindNode(ckt,fast,term,node)
    GENERIC *ckt;
    GENERIC *fast;
    int term;
    GENERIC *node;
{
    int mappednode;
    register int type = ((GENinstance *)fast)->GENmodPtr->GENmodType;

    mappednode = ((CKTnode *)node)->number;

    if(*((*DEVices[type]).DEVpublic.terms) >= term && term >0 ) {
        switch(term) {
            default: return(E_NOTERM);
            case 1:
                ((GENinstance *)fast)->GENnode1 = mappednode;
                break;
            case 2:
                ((GENinstance *)fast)->GENnode2 = mappednode;
                break;
            case 3:
                ((GENinstance *)fast)->GENnode3 = mappednode;
                break;
            case 4:
                ((GENinstance *)fast)->GENnode4 = mappednode;
                break;
            case 5:
                ((GENinstance *)fast)->GENnode5 = mappednode;
                break;
            case 6:/* added to consider the body node 01/06/99 */ 
                ((GENinstance *)fast)->GENnode6 = mappednode;
                break;
            case 7:/* added to consider the temp node 02/03/99 */
                ((GENinstance *)fast)->GENnode7 = mappednode;
                break;
        }
        return(OK);
    } else {
        return(E_NOTERM);
    }
}
